package com.wuban.tron.explore.entity;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 合约表
 * @author sky
 * @date 2020-11-30
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class Contract {
	/**
	 *
	 */
	private Long id;
	/**
	 * 合约code
	 */
	private String bytecode;
	/**
	 * 合约名称
	 */
	private String name;
	/**
	 *
	 */
	private String originAddress;
	/**
	 * 合约ABI
	 */
	private String abi;
	/**
	 *
	 */
	private Long originEnergyLimit;
	/**
	 * 合约地址
	 */
	private String contractAddress;
	/**
	 *
	 */
	private String codeHash;
	/**
	 * solidity版本号
	 */
	private String version;
	/**
	 * 合约代码
	 */
	private String source;
	/**
	 *
	 */
	private String enabled;
	/**
	 *
	 */
	private String other;
	/**
	 *
	 */
	private String runs;
	/**
	 *
	 */
	private String evmVersion;
	/**
	 *
	 */
	private String licenseType;
	/**
	 *
	 */
	private String parameters;
	/**
	 *
	 */
	private String optimization;

	public static Contract getInstance() {
	return Contract.builder()
		       .id(0L)
		       .bytecode("") 
		       .name("") 
		       .originAddress("") 
		       .abi("") 
		       .originEnergyLimit(0L)
		       .contractAddress("") 
		       .codeHash("")
				.version("")
				.source("")
				.enabled("")
				.other("")
				.runs("")
				.evmVersion("")
				.licenseType("")
				.parameters("")
				.optimization("")
			.build();
	}

}