package com.wuban.tron.explore.service;

import com.wuban.tron.explore.entity.LastBlock;

/**
 *  <core>区块高度服务接口</core>
 *
 * @author sky
 * @date 2020/11/02
 */
public interface LastBlockService {

    /**
     * 获取区块高度信息
     * @param id 唯一标识
     * @return LastBlock
     */
    LastBlock getByIdForUpdate(Long id);

    /**
     * 获取区块高度信息:并且更新此高度+1
     * @param id 唯一标识
     * @return Long
     */
    Long getForUpdate(Long id);

    /**
     * 获取区块高度信息
     * @return LastBlock
     */
    LastBlock getOneByExample();

    /**
     * 刷新区块高度：
     *  <ul>
     *      <li>1.系统已设置的区块高度</li>
     *      <li>2.波场最新的区块高度</li>
     *  </ul>
     */
    void refresh();

    /**
     * 同步固定数量的区块号到Redis
     * 如果Redis上没有缓存过区块号，从DB中获取，后续直接操作Redis
     */
    void sync();

}
