package com.wuban.tron.explore.service.impl;

import com.wuban.tron.explore.dao.SolidityVersionRepository;
import com.wuban.tron.explore.entity.SolidityVersion;
import com.wuban.tron.explore.entity.example.SolidityVersionExample;
import com.wuban.tron.explore.service.SolidityVersionService;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <core>solidity版本号服务接口实现类</core>
 *
 * @author sky
 * @date 2020/12/1
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class SolidityVersionServiceImpl implements SolidityVersionService {

    private final SolidityVersionRepository solidityVersionRepository;

    @Override
    public List<SolidityVersion> selectByExample(SolidityVersionExample example) {
        return this.solidityVersionRepository.selectByExample(example);
    }

}
