package com.wuban.tron.explore.util;

import okhttp3.OkHttpClient;

import java.util.concurrent.TimeUnit;

/**
 * Description :
 * 获取okHttpClient单例
 * @author : Jeason
 * @date : Created in 2018/10/25 11:16
 */
public enum OkHttpClientObject {
    CLIENT;

    private OkHttpClient clientInstance;

    private Integer connectTimeout_time = 5;
    private Integer writeTimeout_time = 5;
    private Integer readTimeout_time = 5;

    OkHttpClientObject() {
        clientInstance = new OkHttpClient.Builder()
                .connectTimeout(connectTimeout_time, TimeUnit.SECONDS)
                .writeTimeout(writeTimeout_time, TimeUnit.SECONDS)
                .readTimeout(readTimeout_time, TimeUnit.SECONDS)
                .retryOnConnectionFailure(true)
                .build();
    }

    public OkHttpClient getClientInstance() {
        return clientInstance;
    }
}