package com.wuban.tron.explore.entity;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 区块交易信息表
 * @author sky
 * @date 2020-11-03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class Transaction {
		/**
     * 
     */
	 private Long id; 
		/**
     * 区块ID
     */
	 private String blockId; 
		/**
     * 交易ID
     */
	 private String txId; 
		/**
     * 交易结果
     */
	 private String contractRet; 
		/**
     * 交易地址FROM
     */
	 private String ownerAddress; 
		/**
     * 合约数据
     */
	 private String data; 
		/**
     * 合约地址
     */
	 private String contractAddress; 
		/**
     * 交易额
     */
	 private Long amount; 
		/**
     * 交易地址TO
     */
	 private String toAddress; 
		/**
     * 
     */
	 private String typeUrl; 
		/**
     * 
     */
	 private String type; 
		/**
     * 
     */
	 private String refBlockBytes; 
		/**
     * 
     */
	 private String refBlockHash; 
		/**
     * 
     */
	 private Long expiration; 
		/**
     * 
     */
	 private Long feeLimit; 
		/**
     * 
     */
	 private Long timestamp; 
		/**
     * 创建时间
     */
	 private Date createTime;

	 private Long number;
		
	public static Transaction getInstance() {
	return Transaction.builder()
		       .id(0L)
		       .blockId("") 
		       .txId("") 
		       .contractRet("") 
		       .ownerAddress("") 
		       .data("") 
		       .contractAddress("") 
		       .amount(0L)
		       .toAddress("") 
		       .typeUrl("") 
		       .type("") 
		       .refBlockBytes("") 
		       .refBlockHash("") 
		       .expiration(0L)
		       .feeLimit(0L)
		       .timestamp(0L)
		       .createTime(new Date())
			   .number(0L)
		       .build();
	}
}