package com.wuban.tron.explore.fetch;

import lombok.extern.slf4j.Slf4j;

/**
 *  <core>任务类</core>
 *
 * @author sky
 * @date 2020/11/04
 */
@Slf4j
public abstract class Job implements Runnable {

    /**
     * 是否循环执行
     */
    private volatile boolean loop;

    public Job() {this.loop = true;}

    public Job(final boolean loop) {
        this.loop = loop;
    }

    @Override
    public void run() {
        do {
            execute();
        } while (this.loop && !Thread.currentThread().isInterrupted());
    }

    public void shutdown() {
        this.loop = false;
    }

    public boolean isShutdown() {
        return !this.loop;
    }

    public abstract boolean execute();

}
