package com.wuban.tron.explore.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wuban.tron.explore.constant.PageConstant;
import com.wuban.tron.explore.dao.BlockDayCensusRepository;
import com.wuban.tron.explore.entity.BlockDayCensus;
import com.wuban.tron.explore.entity.example.BlockDayCensusExample;
import com.wuban.tron.explore.service.BlockDayCensusService;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class BlockDayCensusServiceImpl implements BlockDayCensusService {

    private final BlockDayCensusRepository blockDayCensusRepository;

    /**
     * 分页查询
     *
     * @param startIndex 页码
     * @param pageSize   每页记录数
     * @param example    检索条件
     * @return 分页列表
     */
    @Override
    public PageInfo<BlockDayCensus> getByPageWithCategory(Integer startIndex, Integer pageSize, BlockDayCensusExample example) {
        if (startIndex == null) {
            startIndex = PageConstant.DEFAULT_START_INDEX;
        }

        if (pageSize == null) {
            pageSize = PageConstant.DEFAULT_PAGE_SIZE;
        }

        if (pageSize > PageConstant.MAX_PAGE_SIZE) {
            pageSize = PageConstant.MAX_PAGE_SIZE;
        }

        PageHelper.startPage(startIndex, pageSize);
        example.setOrderByClause("`census_date` DESC");
        List<BlockDayCensus> list = this.blockDayCensusRepository.selectByPager(example);
        PageInfo<BlockDayCensus> pageInfo = new PageInfo<>(list);

        return pageInfo;
    }

    @Override
    public List<BlockDayCensus> getByExample(BlockDayCensusExample example) {
        example.setOrderByClause("`census_date`");
        return  this.blockDayCensusRepository.selectByExample(example);
    }

}
