package com.wuban.tron.explore.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class BigDecimalUtil {

    public static final int SCALE = 32;

    public static BigDecimal getDevide(BigDecimal bg1, BigDecimal bg2){
        MathContext mc = new MathContext(SCALE, RoundingMode.HALF_DOWN);
        return bg1.divide(bg2, mc);
    }

    public static BigDecimal getMultiply(BigDecimal bg1, BigDecimal bg2){
        MathContext mc = new MathContext(SCALE, RoundingMode.HALF_UP);
        return bg1.multiply(bg2, mc);
    }

    public static BigDecimal getMultiply(BigDecimal bg1, BigDecimal bg2, int scale){
        MathContext mc = new MathContext(SCALE, RoundingMode.DOWN);
        return bg1.multiply(bg2, mc).setScale(scale, RoundingMode.DOWN);
    }

    public static BigDecimal getAdd(BigDecimal bg1, BigDecimal bg2){
        MathContext mc = new MathContext(SCALE, RoundingMode.HALF_UP);
        return bg1.add(bg2, mc);
    }

    public static BigDecimal getSubtract(BigDecimal bg1, BigDecimal bg2){
        MathContext mc = new MathContext(SCALE, RoundingMode.HALF_UP);
        return bg1.subtract(bg2, mc);
    }

}
