package com.wuban.tron.explore.dao;

import com.wuban.tron.explore.entity.ContractEvent;
import com.wuban.tron.explore.entity.example.ContractEventExample;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <core>合约事件DAO</core>
 *
 * @author sky
 * @date 2020/12/3
 */
@Repository
public interface ContractEventRepository {

    /**
     * 添加合约事件信息
     *
     * @param record
     * @return
     */
    int insert(@Param("record") ContractEvent record);

    /**
     * 批量添加合约事件信息
     * @param records
     * @return
     */
    int batchInsert(@Param("records") List<ContractEvent> records);

    /**
     * 根据条件检索记录数
     * @param example
     * @return
     */
    int countByExample(@Param("example") ContractEventExample example);

    /**
     * 根据条件删除记录
     *
     * @param example
     */
    void deleteByExample(@Param("example") ContractEventExample example);

    /**
     * 根据检索条件获取数据
     *
     * @param example
     * @return
     */
    List<ContractEvent> selectByExample(@Param("example") ContractEventExample example);

}
