package com.wuban.tron.explore.service;

import com.alibaba.fastjson.JSON;
import com.wuban.tron.explore.constant.Constant;
import com.wuban.tron.explore.util.OkHttpClientObject;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import org.springframework.beans.factory.annotation.Value;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 *  <core>公用服务接口方法</core>
 *
 * @author sky
 * @date 2020/11/02
 */
@Slf4j
public abstract class BaseCommonService {

    private static final String PREFIX = "/wallet";

    /**
     * 按照高度查询block API
     */
    protected static final String GET_BLOCK_BYNUM = PREFIX + "/getblockbynum";

    /**
     * 查询最新的几个块API
     */
    protected static final String GET_BLOCK_BYLATESTNUM = PREFIX + "/getblockbylatestnum";


    /**
     * 查询账户信息API
     */
    protected static final String GET_ACCOUNT = PREFIX + "/getaccount";

    /**
     *  事件日志API
     */
    protected static final String CONTRACT_EVENT = "/event/contract/";

    /**
     * 获取合约API
     */
    protected static final String GET_CONTRACT = "/wallet/getcontract";

    private final OkHttpClient client = OkHttpClientObject.CLIENT.getClientInstance();

    @Value("${tron.site}")
    private String tronSite;

    @Value("${contract.complier.site}")
    String contractComplierSite;

    /**
     * http请求
     *
     * @param executeRequest  Request
     *
     * @return String
     */
    protected String execute(Request executeRequest) {
        Response response = null;
        String str = null;

        try {
            response = client.newCall(executeRequest).execute();
            ResponseBody body = response.body();
            if (response.code() == Constant.SUCCESS_CODE && body != null) {
                str = body.string();
            }
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        } finally {
            if (response != null) {
                response.close();
            }
        }

        return str;
    }

    /**
     * 构建请求体
     *
     * @param paramMap  请求参数
     * @return Request
     */
    protected Request builderPost(Map<String, Object> paramMap) {
        String param = JSON.toJSONString(paramMap);
        RequestBody postBody = RequestBody.create(param, Constant.JSON_TYPE);
        return new Request.Builder().url(this.contractComplierSite).post(postBody)
                .addHeader(Constant.CONTENT_TYPE_KEY, Constant.CONTENT_TYPE_VAL).build();
    }

    /**
     * 构建请求体
     *
     * @param uri   合约方法名称
     * @param paramMap  请求参数
     * @return Request
     */
    protected Request builderPost(String uri, Map<String, Object> paramMap) {
        String param = JSON.toJSONString(paramMap);
        RequestBody postBody = RequestBody.create(param, Constant.JSON_TYPE);
        return new Request.Builder().url(this.tronSite + uri).post(postBody)
                .addHeader(Constant.CONTENT_TYPE_KEY, Constant.CONTENT_TYPE_VAL).build();
    }

    /**
     * 构建请求体
     *
     * @param uri   合约方法名称
     * @return Request
     */
    protected Request builderGet(String uri) {
        return new Request.Builder().url(this.tronSite + uri).get()
                .addHeader(Constant.CONTENT_TYPE_KEY, Constant.CONTENT_TYPE_VAL).build();
    }

}
