package com.wuban.tron.explore.entity;

import lombok.*;

/**
 * 账户地址表
 * @author sky
 * @date 2020-11-09
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class Address {
	/**
     * 账户地址
     */
	 private String address;

	 /**
     * 余额
     */
	 private Long balance;

	/**
	 * 冻结余额
	 */
	private Long frozenBalance;
		
	public static Address getInstance() {
	return Address.builder()
		       .address("") 
		       .balance(0L)
			   .frozenBalance(0L)
		       .build();
	}
}