package com.wuban.tron.explore.fetch;

import com.wuban.tron.explore.constant.Constant;
import com.wuban.tron.explore.entity.Census;
import com.wuban.tron.explore.handler.CensusDataHandler;
import com.wuban.tron.explore.handler.ICensusDataHandler;
import com.wuban.tron.explore.util.SpringContextUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 *  <core>统计数据抓取者服务接口方法实现类</core>
 *
 * @author sky
 * @date 2020/11/12
 */
@Slf4j
public class CensusDataFetcher<T> extends AbstractJob implements ICensusDataFetcher {

    private ICensusDataHandler handler;

    private StringRedisTemplate stringRedisTemplate;

    CensusDataFetcher(final CensusDataHandler handler) {
        this.handler = handler;
        stringRedisTemplate = SpringContextUtil.getBean(StringRedisTemplate.class);
    }

    @Override
    public List fetch() {
        List<Census> dataList = new ArrayList<>();

        try {
            // Redis 获取区块大小
            String blockSize = this.stringRedisTemplate.opsForList().rightPop(Constant.CENSUS_BLOCK_SIZE);

            // Redis 获取交易数量
            String transNumber = this.stringRedisTemplate.opsForList().rightPop(Constant.CENSUS_TRANS);

            Census census = new Census();
            boolean flag = false;
            if (!StringUtils.isEmpty(blockSize)) {
                flag = true;
                census.setTotalBlockSize(Long.valueOf(blockSize));
            }
            if (!StringUtils.isEmpty(transNumber)) {
                flag = true;
                census.setTotalTrans(Long.valueOf(transNumber));
            }

            if (flag) {
                dataList.add(census);
            }
        } catch (Exception e) {
            log.info(e.getMessage(), e);
        }

        return dataList;
    }

    @Override
    public void send(List list) throws InterruptedException {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }

        this.handler.receive(list);
    }

    @Override
    public boolean execute() {
        try {
            final List<Census> list = fetch();
            if (CollectionUtils.isEmpty(list)) {
                return false;
            }
            send(list);
            return true;
        } catch (final Exception e) {
            log.error("fetch exception", e);
            return false;
        }
    }
}
