package com.wuban.tron.explore.service.impl;

import com.wuban.tron.explore.domain.TronResponseArrayData;
import com.wuban.tron.explore.domain.TronResponseData;
import com.wuban.tron.explore.service.TronService;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
class TronServiceImplTest {

    @Autowired
    private TronService tronService;

    @Test
    void getBlockByNum() {
        TronResponseData data = this.tronService.getBlockByNum(850000L);
        log.info(data.toString());
    }

    @Test
    void getBlockByLatestNum() {
        TronResponseArrayData data = this.tronService.getBlockByLatestNum(1);
        log.info(data.toString());
    }

    @Test
    void getAccount() {
        this.tronService.getAccount("41705b35c6bb37387cd4cfb57bfc83b74d4374a78a");
    }

}