package com.wuban.tron.explore.handler;

import com.wuban.tron.explore.domain.TronAccount;
import com.wuban.tron.explore.entity.Address;
import com.wuban.tron.explore.fetch.AbstractJob;
import com.wuban.tron.explore.fetch.PersistThreadPool;
import com.wuban.tron.explore.service.AddressService;
import com.wuban.tron.explore.util.SpringContextUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.tron.common.utils.ByteArray;
import org.tron.walletserver.WalletApi;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

/**
 *  <core>账户余额处理者服务接口方法实现类</core>
 *
 * @author sky
 * @date 2020/11/12
 */
@Slf4j
public class AddressBalanceHandler extends AbstractJob implements IAddressBalanceHandler<TronAccount> {

    private AddressService addressService;

    private PersistThreadPool threadPool;

    private final LinkedBlockingQueue<List<TronAccount>> dataList;

    public AddressBalanceHandler() {
        this.dataList = new LinkedBlockingQueue<>();
        addressService = SpringContextUtil.getBean(AddressService.class);
        threadPool = new PersistThreadPool();
    }

    @Override
    public boolean execute() {
        final List<TronAccount> list = this.dataList.poll();
        if(list != null && list.size() != 0) {
            threadPool.getPool().execute(() -> flush(list));
        }
        return true;
    }

    @Override
    public void receive(List<TronAccount> e) throws InterruptedException {
        if (!CollectionUtils.isEmpty(e)) {
            this.dataList.put(e);
        }
    }

    @Override
    public void flush(List<TronAccount> e) {
        if (!CollectionUtils.isEmpty(e)) {
            Address obj = new Address();

            String address = WalletApi.encode58Check(ByteArray.fromHexString(e.get(0).getAddress()));
            obj.setAddress(address);
            obj.setBalance(e.get(0).getBalance());
            this.addressService.updateById(obj);
            log.info("更新账户余额 account:{}", obj.toString());
        }
    }


}
