package com.wuban.tron.explore.dao;

import com.wuban.tron.explore.entity.Transaction;
import com.wuban.tron.explore.entity.example.TransactionExample;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <core>交易DAO</core>
 *
 * @author sky
 * @date 2020/11/02
 */
@Repository
public interface TransactionRepository {

    /**
     * 添加记录
     *
     * @param record
     * @return
     */
    int insert(@Param("record") Transaction record);

    /**
     * 批量添加记录
     *
     * @param records
     * @return
     */
    int batchInsert(@Param("records") List<Transaction> records);

    /**
     * 分页查询
     *
     * @param example 查询条件参数
     * @return 分页记录列表
     */
    List<Transaction> selectByPagerEx(@Param("example") TransactionExample example);

    /**
     * 根据条件检索
     *
     * @param example 检索条件
     * @return
     */
    List<Transaction> selectByExample(@Param("example") TransactionExample example);

    /**
     * 根据账户地址查询交易信息
     *
     * @param address 账户地址
     *
     * @param timestamp
     *
     * @return
     */
    List<Transaction> selectListByAddress(@Param("address") String address, @Param("t") long timestamp);

}
