package com.wuban.tron.explore.service.impl;

import com.wuban.tron.explore.dao.BlockHeaderRepository;
import com.wuban.tron.explore.entity.BlockHeader;
import com.wuban.tron.explore.entity.example.BlockHeaderExample;
import com.wuban.tron.explore.service.BlockHeaderService;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <core>区块头服务接口实现类</core>
 *
 * @author sky
 * @date 2020/11/02
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class BlockHeaderServiceImpl implements BlockHeaderService {

    private final BlockHeaderRepository blockHeaderRepository;

    /**
     * 根据条件检索区块头信息
     *
     * @param example 检索条件
     * @return
     */
    @Override
    public BlockHeader getOneByExample(BlockHeaderExample example) {
        return blockHeaderRepository.selectOneByExample(example);
    }


}
