package com.wuban.tron.explore.dao;

import com.wuban.tron.explore.entity.BlockDayCensus;
import com.wuban.tron.explore.entity.BlockHeader;
import com.wuban.tron.explore.util.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
class BlockHeaderRepositoryTest {

    @Autowired
    private BlockHeaderRepository dao;

    @Autowired
    private BlockDayCensusRepository censusDao;

    BlockHeader blockHeader = null;

    @BeforeEach
    void setUp() {
        blockHeader = new BlockHeader();
        blockHeader.setCreateTime(new Date());
        blockHeader.setTransactionVolume(0);
        blockHeader.setWitnessSignature("ssssssssss");
        blockHeader.setVersion(1);
        blockHeader.setTxTrieRoot("rrrrrrrrrr");
        blockHeader.setParentHash("hhhhhhhhhhhh");
        blockHeader.setNumber(1L);
        blockHeader.setBlockId("bbbbbbbbbbbbbbbb");
    }

    @Test
    void testBatchInsert() {
        List<BlockHeader> list = new ArrayList<>();
        list.add(blockHeader);
        this.dao.batchInsert(list);
    }

    @Test
    void testDateDely() {
        Date nextDate = DateUtil.addDays(new Date(), 1);
        String date = DateUtil.getFormatDate(nextDate,"yyyy-MM-dd") + " 00:00:01";
        Long millis = (DateUtil.getDateFromDateStr(date, DateUtil.PATTERN_YMD_HMS) - System.currentTimeMillis())/1000;
        System.out.println(millis+"--------------------");
    }

    @Test
    void testCensusBlockByTime() {
        BlockDayCensus data = this.censusDao.censusBlockByTime(1600112139000L, 1600113051000L);
        System.out.println(data);
    }

    @Test
    void test() {
        String str = new BigInteger("34ff", 16).toString();
        System.out.println(str);
    }

}