package com.wuban.tron.explore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.wuban.tron.explore.constant.Constant;
import com.wuban.tron.explore.domain.TronAccount;
import com.wuban.tron.explore.domain.TronResponseArrayData;
import com.wuban.tron.explore.domain.TronResponseData;
import com.wuban.tron.explore.service.BaseCommonService;
import com.wuban.tron.explore.service.TronService;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 *  <core>波场区块服务接口实现类</core>
 *
 * @author sky
 * @date 2020/11/02
 */
@Service
@Slf4j
public class TronServiceImpl extends BaseCommonService implements TronService {

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public TronResponseData getBlockByNum(Long blockNum) {
        String str = this.analysisBlock(GET_BLOCK_BYNUM, blockNum);
        if (StringUtils.isEmpty(str)) {
            stringRedisTemplate.opsForList().leftPush(Constant.BLOCK_NUM_LIST_KEY, blockNum.toString());
            log.warn("区块高度blockNum:{}抓取失败，重新放置到队列中.", blockNum);
            return null;
        }

        return JSONObject.parseObject(str, TronResponseData.class);
    }

    @Override
    public TronResponseArrayData getBlockByLatestNum(Integer num) {
        String str = this.analysisBlock(GET_BLOCK_BYLATESTNUM, num);
        if (StringUtils.isEmpty(str)) {
            return null;
        }

        return JSONObject.parseObject(str, TronResponseArrayData.class);
    }

    private String analysisBlock(String interfaceName, Object param) {
        Map<String, Object> map = new HashMap<>(1);
        map.put("num", param);

        Request request = this.builder(interfaceName, map);
        String str = this.execute(request);
        return str;
    }

    /**
     * 根据地址获取账户信息
     *
     * @param address 账户地址
     */
    @Override
    public TronAccount getAccount(String address) {
        Map<String, Object> map = new HashMap<>(1);
        map.put("address", address);

        Request request = this.builder(GET_ACCOUNT, map);
        String str = this.execute(request);
        if (StringUtils.isEmpty(str)) {
            this.stringRedisTemplate.opsForSet().add(Constant.ADDRESS_KEY, address);
            log.warn("账户余额address:{}抓取失败，重新放置到队列中.", address);
            return null;
        }

        return JSONObject.parseObject(str, TronAccount.class);
    }


}
