package com.wuban.tron.explore.entity;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 合约表
 * @author sky
 * @date 2020-11-30
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class Contract {
		/**
     * 
     */
	 private Long id; 
		/**
     * 
     */
	 private String bytecode; 
		/**
     * 名称
     */
	 private String name; 
		/**
     * 
     */
	 private String originAddress; 
		/**
     * 
     */
	 private String abi; 
		/**
     * 
     */
	 private Long originEnergyLimit; 
		/**
     * 合约地址
     */
	 private String contractAddress; 
		/**
     * 
     */
	 private String codeHash; 
		
	public static Contract getInstance() {
	return Contract.builder()
		       .id(0L)
		       .bytecode("") 
		       .name("") 
		       .originAddress("") 
		       .abi("") 
		       .originEnergyLimit(0L)
		       .contractAddress("") 
		       .codeHash("") 
		       .build();
	}
}