package com.wuban.tron.explore.entity;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 合约事件
 * @author sky
 * @date 2020-12-03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class ContractEvent {
		/**
     * 
     */
	 private Long id; 
		/**
     * 
     */
	 private String callerContractAddress; 
		/**
     * 
     */
	 private String result; 
		/**
     * 
     */
	 private String transactionId; 
		/**
     * 
     */
	 private String resultType; 
		/**
     * 
     */
	 private Long blockTimestamp; 
		/**
     * 
     */
	 private Integer blockNumber; 
		/**
     * 
     */
	 private String eventName; 
		/**
     * 
     */
	 private String contractAddress; 
		/**
     * 
     */
	 private Integer eventIndex; 
		
	public static ContractEvent getInstance() {
	return ContractEvent.builder()
		       .id(0L)
		       .callerContractAddress("") 
		       .result("") 
		       .transactionId("") 
		       .resultType("") 
		       .blockTimestamp(0L)
		       .blockNumber(0)
		       .eventName("") 
		       .contractAddress("") 
		       .eventIndex(0)
		       .build();
	}
}