package com.wuban.tron.explore.handler;

import java.util.List;

/**
 *  <core>合约事件处理者服务接口方法</core>
 *
 * @author sky
 * @date 2020/12/4
 */
public interface IContractEventHandler<T> {

    /**
     * 接收合约事件
     *
     * @param e 区块数据
     * @throws InterruptedException 异常
     */
    void receive(List<T> e) throws InterruptedException;

    /**
     * 数据刷入DB
     *
     * @param e 合约事件数据
     */
    void flush(List<T> e);

}
