package com.wuban.tron.explore.service;

import com.wuban.tron.explore.domain.*;
import com.wuban.tron.explore.entity.Contract;

import java.util.List;

/**
 *  <core>波场区块服务接口</core>
 *
 * @author sky
 * @date 2020/11/02
 */
public interface TronService {

    /**
     * 按照高度查询block
     *
     * @param blockNum 是块的高度
     * @return
     */
    TronResponseData getBlockByNum(Long blockNum);

    /**
     * 查询最新的几个块
     *
     * @param num 块的数量
     * @return
     */
    TronResponseArrayData getBlockByLatestNum(Integer num);

    /**
     * 根据地址获取账户信息
     *
     * @param address 账户地址
     * @return  账号信息
     */
    TronAccount getAccount(String address);

    /**
     * 根据合约地址获取事件信息
     *
     * @param address 合约地址
     * @return
     */
    List<TronTransEvent> getContractEvent(String address);

    /**
     * 根据合约地址获取合约信息
     *
     * @param address 合约地址
     * @return
     */
    Contract getContract(String address);

}
