package com.wuban.tron.explore.util;

/**
 * @author sky
 *
 **/
public enum BizExceptionEnum {
	
	/**
	 * 通用异常.
	 */
	SERVER_ERROR(1000, "服务器异常"),
	REQUEST_NULL(1001, "请求参数有错误"),
    SESSION_TIMEOUT(1002, "会话超时"),
    PARAM_INVALID(1003,"参数无效"),
    PARAM_MISS(1004,"参数丢失"),
    METHOD_NOT_ALLOWED(1005, "不支持当前请求类型"),
    SQL_EX(1006, "运行SQL出现异常");


    BizExceptionEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    private Integer code;

    private String message;

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

}
