package com.wuban.tron.explore.handler;

import java.util.List;

/**
 *  <core>区块数据处理者服务接口方法</core>
 *
 * @author sky
 * @date 2020/11/04
 */
public interface IBlockDataHandler<T> {

    /**
     * 接收区块数据
     *
     * @param e 区块数据
     * @throws InterruptedException 异常
     */
    void receive(List<T> e) throws InterruptedException;

    /**
     * 数据刷入DB
     *
     * @param e 区块数据
     */
    void flush(List<T> e);

}
