package com.wuban.tron.explore.service.impl;

import com.wuban.tron.explore.domain.*;
import com.wuban.tron.explore.entity.ContractEvent;
import com.wuban.tron.explore.service.ContractEventService;
import com.wuban.tron.explore.service.TronService;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.util.StringUtils;
import org.junit.runner.RunWith;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.CollectionUtils;
import org.tron.common.utils.ByteArray;
import org.tron.walletserver.WalletApi;

import java.util.ArrayList;
import java.util.List;

@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
class TronServiceImplTest {

    @Autowired
    private TronService tronService;

    @Autowired
    private ContractEventService contractEventService;

    @Test
    void getBlockByNum() {
        TronResponseData data = this.tronService.getBlockByNum(850000L);
        log.info(data.toString());
    }

    @Test
    void getBlockByLatestNum() {
        TronResponseArrayData data = this.tronService.getBlockByLatestNum(1);
        log.info(data.toString());
    }

    @Test
    void getAccount() {
        TronAccount account = this.tronService.getAccount("4151ac26e9d4b3810ce891d660e13202f7cda09a41");
        System.out.println(account.toString());
    }

    @Test
    void getFreezeBalance() {
        String base58check = "THR3xvo49HY6UzFQugRTaeUdgWx7zbkM1k";
        String hexString = ByteArray.toHexString(WalletApi.decodeFromBase58Check(base58check));
        log.info(hexString);
    }

    @Test
    void getContractEvent() {
        List<TronTransEvent> data = this.tronService.getContractEvent("TMypW2w7P2y8QzV8i9BAE31yzQukp63tbo");
        System.out.println(data);
    }

    @Test
    void getContract() {
        String base58check = "TTfwGdf3v66CaYQijg4Qb2CFtdgQnkkFko";
        String hexString = ByteArray.toHexString(WalletApi.decodeFromBase58Check(base58check));
        System.out.println(hexString);
        this.tronService.getContract(hexString);
    }


}