package com.wuban.tron.explore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.wuban.tron.explore.domain.TronAccount;
import com.wuban.tron.explore.domain.TronResponseArrayData;
import com.wuban.tron.explore.domain.TronResponseData;
import com.wuban.tron.explore.service.BaseCommonService;
import com.wuban.tron.explore.service.TronService;
import okhttp3.Request;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 *  <core>波场区块服务接口实现类</core>
 *
 * @author sky
 * @date 2020/11/02
 */
@Service
public class TronServiceImpl extends BaseCommonService implements TronService {

    @Override
    public TronResponseData getBlockByNum(Long blockNum) {
        String str = this.analysisBlock(GET_BLOCK_BYNUM, blockNum);
        if (StringUtils.isEmpty(str)) {
            return null;
        }

        return JSONObject.parseObject(str, TronResponseData.class);
    }

    @Override
    public TronResponseArrayData getBlockByLatestNum(Integer num) {
        String str = this.analysisBlock(GET_BLOCK_BYLATESTNUM, num);
        if (StringUtils.isEmpty(str)) {
            return null;
        }

        return JSONObject.parseObject(str, TronResponseArrayData.class);
    }

    private String analysisBlock(String interfaceName, Object param) {
        Map<String, Object> map = new HashMap<>(1);
        map.put("num", param);

        Request request = this.builder(interfaceName, map);
        String str = this.execute(request);
        return str;
    }

    /**
     * 根据地址获取账户信息
     *
     * @param address 账户地址
     */
    @Override
    public TronAccount getAccount(String address) {
        Map<String, Object> map = new HashMap<>(1);
        map.put("address", address);

        Request request = this.builder(GET_ACCOUNT, map);
        String str = this.execute(request);
        if (StringUtils.isEmpty(str)) {
            return null;
        }

        return JSONObject.parseObject(str, TronAccount.class);
    }


}
