package com.wuban.tron.explore.service.impl;

import com.wuban.tron.explore.domain.TronAccount;
import com.wuban.tron.explore.domain.TronResponseArrayData;
import com.wuban.tron.explore.domain.TronResponseData;
import com.wuban.tron.explore.service.TronService;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.tron.common.utils.ByteArray;
import org.tron.walletserver.WalletApi;

@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
class TronServiceImplTest {

    @Autowired
    private TronService tronService;

    @Test
    void getBlockByNum() {
        TronResponseData data = this.tronService.getBlockByNum(850000L);
        log.info(data.toString());
    }

    @Test
    void getBlockByLatestNum() {
        TronResponseArrayData data = this.tronService.getBlockByLatestNum(1);
        log.info(data.toString());
    }

    @Test
    void getAccount() {
        TronAccount account = this.tronService.getAccount("4151ac26e9d4b3810ce891d660e13202f7cda09a41");
        System.out.println(account.toString());
    }

    @Test
    void getFreezeBalance() {
        String base58check = "THR3xvo49HY6UzFQugRTaeUdgWx7zbkM1k";
        String hexString = ByteArray.toHexString(WalletApi.decodeFromBase58Check(base58check));
        log.info(hexString);
    }


}