package com.wuban.tron.explore.controller;

import com.wuban.tron.explore.entity.Contract;
import com.wuban.tron.explore.entity.example.ContractExample;
import com.wuban.tron.explore.param.request.ContractRequest;
import com.wuban.tron.explore.service.ContractComplierService;
import com.wuban.tron.explore.service.ContractService;
import com.wuban.tron.explore.service.TronService;
import com.wuban.tron.explore.util.ApiResponse;
import com.wuban.tron.explore.util.BizExceptionEnum;
import com.wuban.tron.explore.util.ResponseKit;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * <core>合约校验API接口</core>
 *
 * @author sky
 * @date 2020/11/30
 */
@Slf4j
@RestController
@RequestMapping("/api/explorer/v1/")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ContractController {

    private final ContractService contractService;

    private final TronService tronService;

    private final ContractComplierService contractComplierService;

    @RequestMapping(value="compileSolidity", method = RequestMethod.POST)
    public ApiResponse checkContract(@RequestBody @Valid ContractRequest reqParam) {

        String address = reqParam.getAddress();
        if (StringUtils.isEmpty(address)) {
            return ResponseKit.fail(BizExceptionEnum.REQUEST_NULL.getCode(),BizExceptionEnum.REQUEST_NULL.getMessage());
        }

        /*
            按照合约地址查询DB中是否存在此合约，如果不存在，调用链上接口API
         */
        ContractExample example = new ContractExample();
        example.createCriteria().andContractAddressEqualTo(address);
        Contract con = this.contractService.selectOneByExample(example);
        if (con != null) {
            return ResponseKit.success(con);
        }

        // 调用链上接口API
        Contract contract = this.tronService.getContract(address);
        if (contract == null) {
            return ResponseKit.fail(BizExceptionEnum.SERVER_ERROR.getCode(),BizExceptionEnum.SERVER_ERROR.getMessage());
        }

        // 编译合约
        String code = this.contractComplierService.complier(reqParam.getName(), reqParam.getValue(), reqParam.getCompiler());

        // 校验btyecode是否一致，不一致返回，一致持久化
        if (!contract.getBytecode().equals(code)) {
            return ResponseKit.fail(BizExceptionEnum.SERVER_ERROR.getCode(),BizExceptionEnum.SERVER_ERROR.getMessage());
        }

        this.contractService.insert(contract);

        return ResponseKit.success();
    }


}
