package com.wuban.tron.explore.entity;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 账户地址表
 * @author sky
 * @date 2020-11-09
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class Address {
		/**
     * 账户地址
     */
	 private String address; 
		/**
     * 余额
     */
	 private Long balance; 
		
	public static Address getInstance() {
	return Address.builder()
		       .address("") 
		       .balance(0L)
		       .build();
	}
}