package com.wuban.tron.explore.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 按天统计区块表
 * @author sky
 * @date 2020-11-04
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class BlockDayCensus {
		/**
     * 
     */
	 private Long id; 
		/**
     * 生成区块的平均时间
     */
	 private Long genBlockAverTime; 
		/**
     * 生成区块总量
     */
	 private Integer genBlockTotalNum; 
		/**
     * 总交易量
     */
	 private Integer totalVolume; 
		/**
     * 统计日期
     */
	 private String censusDate;

	 private Integer totalBlockBytes;

	 private Integer averBlockBytes;

		/**
     * 
     */
	 @JsonIgnore
	 private Date createTime; 
		
	public static BlockDayCensus getInstance() {
	return BlockDayCensus.builder()
		       .id(0L)
		       .genBlockAverTime(0L)
		       .genBlockTotalNum(0)
		       .totalVolume(0)
		       .censusDate("")
			   .totalBlockBytes(0)
			   .averBlockBytes(0)
		       .createTime(null)
		       .build();
	}
}