package com.wuban.tron.explore.entity;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 区块交易hex表
 * @author sky
 * @date 2020-11-03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class TransactionHex {
		/**
     * 
     */
	 private Long id; 
		/**
     * 
     */
	 private String hex; 
		/**
     * 区块ID
     */
	 private String blockId; 
		/**
     * 交易ID
     */
	 private String txId; 
		/**
     * 
     */
	 private String signature; 
		/**
     * 创建时间
     */
	 private Date createTime; 
		
	public static TransactionHex getInstance() {
	return TransactionHex.builder()
		       .id(0L)
		       .hex("") 
		       .blockId("") 
		       .txId("") 
		       .signature("") 
		       .createTime(new Date())
		       .build();
	}
}