package com.wuban.tron.explore.dao;

import com.wuban.tron.explore.entity.BlockHeader;
import com.wuban.tron.explore.entity.Transaction;
import com.wuban.tron.explore.entity.example.BlockHeaderExample;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <core>区块头DAO</core>
 *
 * @author sky
 * @date 2020/11/02
 */
@Repository
public interface BlockHeaderRepository {

    /**
     * 添加记录
     *
     * @param record
     * @return
     */
    int insert(@Param("record") BlockHeader record);

    /**
     * 批量：持久化区块头信息
     * @param records 区块头信息
     * @return
     */
    int batchInsert(@Param("records") List<BlockHeader> records);

    /**
     * 获取所有区块头中最小时间
     *
     * @return 时间
     */
    Long selectBlockMinTime();

    /**
     * 根据条件检索区块头信息
     *
     * @param example 检索条件
     * @return
     */
    BlockHeader selectOneByExample(@Param("example")BlockHeaderExample example);

    /**
     * 分页查询
     *
     * @param example 查询条件参数
     * @return 分页记录列表
     */
    List<BlockHeader> selectByPagerEx(@Param("example") BlockHeaderExample example);

}
