package com.wuban.tron.explore.entity;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 区块头信息表
 * @author sky
 * @date 2020-11-03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class BlockHeader {
		/**
     * 
     */
	 private Long id; 
		/**
     * 区块ID
     */
	 private String blockId; 
		/**
     * 区块高度
     */
	 private Long number; 
		/**
     * 
     */
	 private String txTrieRoot; 
		/**
     * 
     */
	 private String witnessAddress; 
		/**
     * 父hash
     */
	 private String parentHash; 
		/**
     * 版本号
     */
	 private Integer version; 
		/**
     * 区块时间戳
     */
	 private Long timestamp; 
		/**
     * 
     */
	 private String witnessSignature; 
		/**
     * 交易量
     */
	 private Integer transactionVolume; 
		/**
     * 创建时间
     */
	 private Date createTime;

	/**
	 * 块大小
	 */
	private String blockBytes;
		
	public static BlockHeader getInstance() {
	return BlockHeader.builder()
		       .id(0L)
		       .blockId("") 
		       .number(0L)
		       .txTrieRoot("") 
		       .witnessAddress("") 
		       .parentHash("") 
		       .version(0)
		       .timestamp(0L)
		       .witnessSignature("") 
		       .transactionVolume(0)
		       .createTime(new Date())
			   .blockBytes("")
		       .build();
	}
}