package com.wuban.tron.explore.controller;

import com.wuban.tron.explore.param.request.CensusRequest;
import com.wuban.tron.explore.service.TransactionService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * <core>区块统计API</core>
 *
 * @author sky
 * @date 2020/11/12
 */
@Slf4j
@RestController
@RequestMapping("/census")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class CensusController {

    private final TransactionService transactionService;

    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<>());

    @RequestMapping(method = RequestMethod.POST)
    public void census(@RequestBody @Valid CensusRequest reqParam) {
        this.pool.execute(() -> this.transactionService.censusBlockByDate(reqParam.getStartDate(), reqParam.getEndDate()));
    }

}
