package com.wuban.tron.explore.param.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.wuban.tron.explore.entity.Transaction;
import lombok.Builder;
import lombok.Data;

import java.util.Date;

/**
 * 区块详情MODEL
 *
 * @author wuban-team
 * @date 2020-11-16
 */
@Data
@Builder
public class BlockInfoModel {

    private long number;
    private String timestamp;
    private String miner;
    private String mined_time;
    private String block_reward;
    private String uncles_reward;
    private String difficulty;
    private String totalDifficulty;
    private String size;
    private String extraData;
    private String hash;
    private String mixHash;
    private String parentHash;
    private String sha3Uncles;
    private String stateRoot;
    private String receiptsRoot;
    private String transactionsRoot;
    private String nonce;
    private String gasUsed;
    private String gasLimit;
    @JsonProperty(value="Transaction")
    private Object transaction;
    private int trans_number;

    public static BlockInfoModel getInstance() {
        return BlockInfoModel.builder()
                .number(0L)
                .timestamp("")
                .miner("")
                .mined_time("")
                .block_reward("")
                .uncles_reward("")
                .difficulty("")
                .totalDifficulty("")
                .size("")
                .extraData("")
                .hash("")
                .mixHash("")
                .parentHash("")
                .sha3Uncles("")
                .stateRoot("")
                .receiptsRoot("")
                .transactionsRoot("")
                .nonce("")
                .gasUsed("")
                .gasLimit("")
                .build();
    }


}
