package com.wuban.tron.explore.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wuban.tron.explore.constant.PageConstant;
import com.wuban.tron.explore.dao.BlockHeaderRepository;
import com.wuban.tron.explore.entity.BlockHeader;
import com.wuban.tron.explore.entity.example.BlockHeaderExample;
import com.wuban.tron.explore.service.BlockHeaderService;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <core>区块头服务接口实现类</core>
 *
 * @author sky
 * @date 2020/11/02
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class BlockHeaderServiceImpl implements BlockHeaderService {

    private final BlockHeaderRepository blockHeaderRepository;

    /**
     * 根据条件检索区块头信息
     *
     * @param example 检索条件
     * @return
     */
    @Override
    public BlockHeader getOneByExample(BlockHeaderExample example) {
        return blockHeaderRepository.selectOneByExample(example);
    }

    /**
     * 分页查询
     *
     * @param example 查询条件参数
     * @return 分页记录列表
     */
    @Override
    public PageInfo<BlockHeader> getByPagerEx(Integer startIndex, Integer pageSize, BlockHeaderExample example) {
        if (startIndex == null) {
            startIndex = PageConstant.DEFAULT_START_INDEX;
        }

        if (pageSize == null) {
            pageSize = PageConstant.DEFAULT_PAGE_SIZE;
        }

        if (pageSize > PageConstant.MAX_PAGE_SIZE) {
            pageSize = PageConstant.MAX_PAGE_SIZE;
        }

        example.setOrderByClause("`timestamp` DESC");
        PageHelper.startPage(startIndex, pageSize);
        List<BlockHeader> list = this.blockHeaderRepository.selectByPagerEx(example);
        PageInfo<BlockHeader> pageInfo = new PageInfo<>(list);

        return pageInfo;
    }


}
