package com.wuban.tron.explore.handler;

import java.util.List;

/**
 *  <core>统计数据处理者服务接口方法</core>
 *
 * @author sky
 * @date 2020/11/24
 */
public interface ICensusDataHandler<T> {

    /**
     * 接收统计数据
     *
     * @param e 区块数据
     * @throws InterruptedException 异常
     */
    void receive(List<T> e) throws InterruptedException;

    /**
     * 数据刷入DB
     *
     * @param e 用户余额数据
     */
    void flush(List<T> e);

}
