package com.wuban.tron.explore.constant;

import okhttp3.MediaType;
import org.springframework.beans.factory.annotation.Value;

/**
 * <core>常量定义类</core>
 *
 * @author sky
 * @date 2020/11/02
 */
public class Constant {

    /**
     * 结果码：
     */
    public static final int SUCCESS_CODE = 200;

    /**
     * 波场API地址
     */
    public static final String HOST = "https://api.shasta.trongrid.io";

    /**
     * 请求数据类型：JSON
     */
    public static final MediaType JSON_TYPE = MediaType.parse("application/json");
    public static final String CONTENT_TYPE_KEY = "Content-Type";
    public static final String CONTENT_TYPE_VAL = "application/json";

    public static final String OS_NMAE = "WINDOWS";

    public static final long FIVE_THOUSAND = 5000;

    /**
     * 区块高度：已同步
     */
    public static final String BLOCK_NUM_KEY = "block_num";

    /**
     * 需要同步区块列表
     */
    public static final String BLOCK_NUM_LIST_KEY = "block_num_list";

    /**
     * 账户地址：根据此地址抓取账户余额
     */
    public static final String ADDRESS_KEY = "address";

    /**
     * 数据统计：根据此数据（账户数量、交易数量、区块大小）更新DB统计信息
     */
    public static final String CENSUS_ADDRESS = "census_address";
    public static final String CENSUS_TRANS = "census_trans";
    public static final String CENSUS_BLOCK_SIZE = "census_block_size";

    /**
     * 数据同步阀值
     */
    public static final long THRESHOLD = 30000;

    /**
     *  用户地址长度
     */
    public static final int USER_ADDRESS_LEN = 34;

    /**
     *  txID长度
     */
    public static final int TX_ID_LEN = 64;

    public static final String EXCUTOR_NAME_ACCOUNT = "抓取余额Pool";

    public static final String EXCUTOR_NAME_BLOCK = "抓取区块Pool";

}
