package com.wuban.tron.explore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.wuban.tron.explore.service.BaseCommonService;
import com.wuban.tron.explore.service.ContractCompilerService;
import com.wuban.tron.explore.util.ApiResponse;
import okhttp3.Request;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * <core>编译合约服务接口实现类</core>
 *
 * @author sky
 * @date 2020/11/30
 */
@Service
public class ContractCompilerServiceImpl extends BaseCommonService implements ContractCompilerService {

    @Override
    public String compiler(String name, String value, String compiler) {
        Map<String, Object> map = new HashMap<>(3);
        map.put("name", name);
        map.put("value", value);
        map.put("compiler", compiler);
        Request request = this.builderPost(map);
        String str = this.execute(request);
        if (StringUtils.isEmpty(str)) {
            return null;
        }

        return (String) JSONObject.parseObject(str, ApiResponse.class).getData();
    }


}
