package com.wuban.tron.explore.dao;

import com.wuban.tron.explore.entity.Address;
import com.wuban.tron.explore.entity.example.AddressExample;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <core>账户DAO</core>
 *
 * @author sky
 * @date 2020/11/02
 */
@Repository
public interface AddressRepository {

    /**
     * 批量添加、更新账户地址信息
     *
     * @param records
     */
    void batchInsertOnDuplicateKey(@Param("records") List<Address> records);

    /**
     * 获取账户地址信息
     *
     * @param example 查询条件参数
     * @return 记录
     */
    Address selectOneByExample(@Param("example") AddressExample example);


    /**
     *  修改账户信息
     *
     * @param record
     */
    void updateById(@Param("record") Address record);

    /**
     * 分页查询
     *
     * @param example 查询条件参数
     * @return 分页记录列表
     */
    List<Address> selectByPager(@Param("example") AddressExample example);

}