package com.wuban.tron.explore.dao;

import com.wuban.tron.explore.entity.LastBlock;
import com.wuban.tron.explore.entity.example.LastBlockExample;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * <core>最新统计区块DAO</core>
 *
 * @author sky
 * @date 2020/11/02
 */
@Repository
public interface LastBlockRepository {

    /**
     * 获取最新统计的区块
     *
     * @param id
     * @return
     */
    LastBlock selectByIdForUpdate(@Param("id") Long id);

    /**
     * 获取最新统计的区块
     *
     * @param example
     * @return
     */
    LastBlock selectOneByExample(@Param("example") LastBlockExample example);

    /**
     * 更新统计的区块
     *
     * @param record
     * @return
     */
    int updateById(@Param("record") LastBlock record);

    /**
     * 更新统计的区块
     *
     * @param record
     * @return
     */
    int updateCurBlockNumById(@Param("record") LastBlock record);

}