package com.wuban.tron.explore.service;

import com.github.pagehelper.PageInfo;
import com.wuban.tron.explore.entity.BlockDayCensus;
import com.wuban.tron.explore.entity.example.BlockDayCensusExample;

import java.util.List;

/**
 * <core>区块统计服务接口</core>
 *
 * @author sky
 * @date 2020/11/02
 */
public interface BlockDayCensusService {

    /**
     * 分页查询
     *
     * @param startIndex 页码
     * @param pageSize  每页记录数
     * @param example   检索条件
     * @return 分页列表
     */
    PageInfo<BlockDayCensus> getByPageWithCategory(Integer startIndex, Integer pageSize, BlockDayCensusExample example);

    /**
     * 获取统计列表
     *
     * @param example 检索条件
     * @return
     */
    List<BlockDayCensus> getByExample(BlockDayCensusExample example);


}
