package com.wuban.tron.explore.service;

import com.github.pagehelper.PageInfo;
import com.wuban.tron.explore.entity.Address;
import com.wuban.tron.explore.entity.example.AddressExample;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <core>账户服务接口</core>
 *
 * @author sky
 * @date 2020/11/02
 */
public interface AddressService {

    /**
     * 批量添加、更新账户地址信息
     *
     * @param records
     */
    void batchInsertOnDuplicateKey(@Param("records") List<Address> records);

    /**
     *  修改账户信息
     *
     * @param record
     */
    void updateById(@Param("record") Address record);

    /**
     * 获取账户地址信息
     *
     * @param example 查询条件参数
     * @return 记录
     */
    Address selectOneByExample(@Param("example") AddressExample example);

    /**
     * 分页查询
     *
     * @param example 查询条件参数
     * @param  startIndex
     * @param  pageSize
     * @return 分页记录列表
     */
    PageInfo<Address> selectByPager(Integer startIndex, Integer pageSize, AddressExample example);

}
