package com.wuban.tron.explore.service.impl;

import com.wuban.tron.explore.dao.AddressRepository;
import com.wuban.tron.explore.entity.Address;
import com.wuban.tron.explore.entity.example.AddressExample;
import com.wuban.tron.explore.service.AddressService;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class AddressServiceImpl implements AddressService {

    private final AddressRepository addressRepository;

    @Override
    public void batchInsertOnDuplicateKey(List<Address> records) {
        this.addressRepository.batchInsertOnDuplicateKey(records);
    }

    @Override
    public void updateById(Address record) {
        this.addressRepository.updateById(record);
    }

    /**
     * 获取账户地址信息
     *
     * @param example 查询条件参数
     * @return 记录
     */
    @Override
    public Address selectOneByExample(AddressExample example) {
        return this.addressRepository.selectOneByExample(example);
    }

}
