package com.wuban.tron.explore.service;

import com.wuban.tron.explore.entity.Address;
import com.wuban.tron.explore.entity.example.AddressExample;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface AddressService {

    /**
     * 批量添加、更新账户地址信息
     *
     * @param records
     */
    void batchInsertOnDuplicateKey(@Param("records") List<Address> records);

    /**
     *  修改账户信息
     *
     * @param record
     */
    void updateById(@Param("record") Address record);

    /**
     * 获取账户地址信息
     *
     * @param example 查询条件参数
     * @return 记录
     */
    Address selectOneByExample(@Param("example") AddressExample example);

}
