package com.wuban.tron.explore.util;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 *  <core>SpringContextUtil</core>
 *
 * @author sky
 * @date 2020/11/04
 */
@Component
public class SpringContextUtil implements ApplicationContextAware {

    /**
     * Spring应用上下文环境
     */
    private static ApplicationContext applicationContext;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    @Override
    public void setApplicationContext(final ApplicationContext applicationContext) throws BeansException {
        SpringContextUtil.applicationContext = applicationContext;
    }

    public static <T> T getBean(final String name) throws BeansException {
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(final Class<T> clazz) throws BeansException {
        return applicationContext.getBean(clazz);
    }

}
