package com.wuban.tron.explore.dao;

import com.wuban.tron.explore.entity.Census;
import com.wuban.tron.explore.entity.example.CensusExample;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * <core>数据统计DAO</core>
 *
 * @author sky
 * @date 2020/11/25
 */
@Repository
public interface CensusRepository {

    /**
     * 添加统计信息
     *
     * @param record
     * @return
     */
    int insert(@Param("record") Census record);

    /**
     * 查询统计信息
     *
     * @param example 检索条件
     * @return
     */
    Census selectOneByExample(@Param("example") CensusExample example);

    /**
     * 根据主键更新统计信息
     *
     * @param record
     */
    void updateById(@Param("record") Census record);


}
