package com.wuban.tron.explore.fetch;

import lombok.extern.slf4j.Slf4j;

/**
 *  <core>任务类</core>
 *
 * @author sky
 * @date 2020/11/04
 */
@Slf4j
public abstract class AbstractJob implements Runnable {

    /**
     * 是否循环执行
     */
    private volatile boolean loop;

    public AbstractJob() {this.loop = true;}

    public AbstractJob(final boolean loop) {
        this.loop = loop;
    }

    @Override
    public void run() {
        do {
            execute();
        } while (this.loop && !Thread.currentThread().isInterrupted());
    }

    public void shutdown() {
        this.loop = false;
    }

    public boolean isShutdown() {
        return !this.loop;
    }

    /**
     * 执行方法
     *
     * @return
     */
    public abstract boolean execute();

}
