package com.wuban.tron.explore.service.impl;

import com.wuban.tron.explore.dao.ContractRepository;
import com.wuban.tron.explore.entity.Contract;
import com.wuban.tron.explore.entity.example.ContractExample;
import com.wuban.tron.explore.service.ContractService;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <core>合约服务接口实现类</core>
 *
 * @author sky
 * @date 2020/11/30
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ContractServiceImpl implements ContractService {

    private final ContractRepository contractRepository;

    /**
     * 添加合约信息
     *
     * @param record
     * @return
     */
    @Override
    public int insert(Contract record) {
        return this.contractRepository.insert(record);
    }

    /**
     * 查询合约信息
     *
     * @param example 检索条件
     * @return
     */
    @Override
    public Contract selectOneByExample(ContractExample example) {
        return this.contractRepository.selectOneByExample(example);
    }


}
