package com.wuban.tron.explore.util;

import com.wuban.tron.explore.constant.Constant;
import lombok.extern.slf4j.Slf4j;
import sun.awt.OSInfo;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author sky
 *
 */
@Slf4j
public class ThreadPoolUtil {

    private static final Long TIMEOUT = 1000L;

    /**
     * 确保关闭线程池
     *
     * @param pool 线程池
     */
    public static void ensureShutdown(final ThreadPoolExecutor pool) {
        pool.shutdownNow();
        try {
            while (!pool.awaitTermination(TIMEOUT, TimeUnit.MILLISECONDS)) {
                log.info("still not shutdown");
            }
        } catch (final InterruptedException e) {
            log.error("interrepted", e);
        }
        log.info("shutdown over");
    }

    public static int getCupNum() {
        int cupNum;
        String osName = OSInfo.getOSType().name();
        if (osName.equals(Constant.OS_NMAE)) {
            cupNum = Runtime.getRuntime().availableProcessors();
        } else {
            cupNum = Runtime.getRuntime().availableProcessors() * 2;
        }

        return cupNum;
    }

}
